importPackage(java.io);
importPackage(java.lang);
importPackage(org.apache.commons.io);
importPackage(com.os.renditionplus.scriptexecutor);

function process(scriptPathName, applicationBase, timeout, sourceFileName, targetFileName)
{
	try
	{
		println("libreoffice2pdf (2013-06-30)");

		var targetFile = new File(targetFileName);
		var targetPathFile = targetFile.getParentFile();
		
		targetPathFile.mkdir();

		var executor = new ScriptExecutor();
		executor.setTimeout(timeout);
		executor.setWorkingDirectory([WorkingDirectory]);
		// executor.setDebug(true);

		executor.execute([soffice.exe], "--invisible", "--nologo", "--nodefault", "--convert-to", "pdf", "--outdir", targetFile.getParent(), sourceFileName);

		// prepare file for output
		var sourceFile = new File(sourceFileName);
		sourceFileName = FilenameUtils.getBaseName(sourceFile);
		
		var renamedTargetFile = new File(targetPathFile, sourceFileName + ".pdf");
		
		renamedTargetFile.renameTo(targetFile);

	} catch (e)
	{
		// file['delete']();
		FileUtils.deleteQuietly(new File(targetFileName));
		println(e);
		System.exit(-1);
	}
}