﻿$inputPath = $args[0]

if (!$inputPath -Or !(Test-Path -PathType Container $inputPath)) {
  Write-Host Usage: $MyInvocation.MyCommand "{directory}"
  Exit 1
}

[string[]] $srcLines
[string[]] $destLines

Get-ChildItem "$inputPath\*" -Recurse -Include *.htm, *.html | 
Foreach-Object {
  Write-Host $_
  $srcLines = @()
  $destLines = @()
  $srcLines = Get-Content -Path "$_" -Encoding Default
  $found = 0
  foreach ( $line in $srcLines ) {
    $index = $line.IndexOf("<script");
    if ($found -ne 1 -And $index -ne -1) {
      $found = 1
      $destLines += $line.Substring(0, $index)
      $destLines += "<script data-cookieconsent=`"ignore`">
        
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
        
            gtag(`"consent`", `"default`", {
                ad_storage: `"denied`",
                analytics_storage: `"denied`",
                functionality_storage: `"denied`",
                personalization_storage: `"denied`",
                security_storage: `"granted`",
                wait_for_update: 500,
            });
        
            gtag(`"set`", `"ads_data_redaction`", true);
        
        </script>
        
                 <!-- Google Tag Manager -->
        <script data-cookieconsent=`"ignore`">(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-MQW2GQ7');</script>
        <!-- End Google Tag Manager -->
        <script id=`"Cookiebot`" src=`"https://consent.cookiebot.com/uc.js`" data-cbid=`"a03f5cc7-af9b-4fa5-ac34-52efe32a8a8b`" data-blockingmode=`"auto`" type=`"text/javascript`"></script>"
      $destLines += $line.Substring($index)
    } else {
      $destLines += $line
    }
  }
  $destLines | Out-File -FilePath "$_" -Force -Encoding Default
}